{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Tel.: +0351-8012255                   =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 20.01.1998 - 18:00:00 $                                      =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMDSPObj, MMWave, MMDSMix, MMObj, MMDesign, StdCtrls, ExtCtrls, MMD3DTyp,
  MMHTimer, MMCstDlg, MMDSEdtr;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    MMDSWaveMixer1: TMMDSWaveMixer;
    btnPlay: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Button2: TButton;
    MMDSMixChannel1: TMMDSMixChannel;
    MMDSMixChannel2: TMMDSMixChannel;
    MMDSMixChannel3: TMMDSMixChannel;
    chkUse3D: TCheckBox;
    btnWave: TButton;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    MMDSEditor1: TMMDSEditor;
    procedure chkUse3DClick(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnWaveClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FOpened     : Boolean;
    FPlaying    : Boolean;

    procedure   UpdateEnable;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.chkUse3DClick(Sender: TObject);
begin
    MMDSWaveMixer1.Use3D := chkUse3D.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
var
    Ind: Integer;
    C  : TMMDSMixChannel;
begin
    Ind := (Sender as TComponent).Tag;
    C   := FindComponent('MMDSMixChannel'+IntToStr(Ind)) as TMMDSMixChannel;
    if C <> nil then
        C.Muted := not (Sender as TCheckBox).Checked;
end;

procedure TForm1.btnPlayClick(Sender: TObject);
begin
    if not FOpened then
        Exit;
    FPlaying := True;
    UpdateEnable;
    MMDSMixChannel1.Play;
    MMDSMixChannel2.Play;
    MMDSMixChannel3.Play;
end;

procedure TForm1.btnWaveClick(Sender: TObject);
begin
    if not FPlaying then
        if MMWaveOpenDialog1.Execute then
        begin
            MMDSMixChannel1.Wave.FileName := MMWaveOpenDialog1.FileName;
            MMDSMixChannel2.Wave.FileName := MMWaveOpenDialog1.FileName;
            MMDSMixChannel3.Wave.FileName := MMWaveOpenDialog1.FileName;
            FOpened := True;
            UpdateEnable;
        end;
end;

procedure   TForm1.UpdateEnable;
begin
    btnWave.Enabled := not FPlaying;
    btnPlay.Enabled := FOpened;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
    UpdateEnable;
end;

end.
